/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.Constants;
import fabric.com.hollingsworth.schematic.api.blockprints.ApiError;
import fabric.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import fabric.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import fabric.com.hollingsworth.schematic.client.gui.GuiImageButton;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.client.gui.HomeScreen;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class LoadingScreen<T>
extends BaseSchematicScreen {
    int ticksRunning;
    boolean backAdded = false;
    boolean addHomeButton = false;
    int anim;
    Supplier<ApiResponse<T>> future;
    Consumer<T> onSuccess;
    String error = null;
    public boolean responseHandled = false;
    Response<T> response;
    public class_437 previousScreen = null;
    CompletableFuture<ApiResponse<T>> completableFuture;

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess, class_437 previousScreen) {
        this(future, onSuccess);
        this.previousScreen = previousScreen;
    }

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess, class_437 previousScreen, int ticksRunning) {
        this(future, onSuccess, previousScreen);
        this.ticksRunning = ticksRunning;
    }

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess) {
        this.future = future;
        this.onSuccess = onSuccess;
        this.completableFuture = CompletableFuture.supplyAsync(future, class_156.method_18349()).whenCompleteAsync((result, err) -> {
            this.response = new Response(result, (Throwable)err);
        }, (Executor)class_310.method_1551());
    }

    @Override
    public void method_25426() {
        super.method_25426();
    }

    public void handleResponse() {
        if (this.response == null) {
            return;
        }
        this.responseHandled = true;
        ApiResponse<T> apiResponse = this.response.response();
        if (this.response.throwable != null) {
            CompletionException completionException;
            Throwable throwable = this.response.throwable;
            if (throwable instanceof CompletionException && (throwable = (completionException = (CompletionException)throwable).getCause()) instanceof ApiError) {
                ApiError apiError = (ApiError)throwable;
                apiResponse = apiError.toApiResponse();
            } else {
                this.response.throwable.printStackTrace();
                this.error = class_2561.method_43469((String)"blockprints.unexpected_error", (Object[])new Object[]{this.response.throwable.getMessage()}).getString();
                this.addHomeButton();
                return;
            }
        }
        if (apiResponse == null || apiResponse.response == null && apiResponse.error == null) {
            Constants.LOG.error("Empty response with no error.");
            this.error = class_2561.method_43471((String)"blockprints.unexpected_error").getString();
            this.addHomeButton();
            return;
        }
        if (apiResponse.error != null) {
            this.error = apiResponse.error;
            Constants.LOG.error("Error: " + apiResponse.error);
            this.addHomeButton();
        } else {
            this.onSuccess.accept(apiResponse.response);
        }
    }

    public void method_25393() {
        super.method_25393();
        ++this.ticksRunning;
        ++this.anim;
        if (this.anim > 50) {
            this.anim = 0;
        }
        if (this.response != null && !this.responseHandled) {
            this.handleResponse();
        }
        if (!(this.ticksRunning != 100 && this.error == null || this.backAdded)) {
            this.method_37063(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new class_2960("blockprints", "textures/gui/button_back.png"), b -> class_310.method_1551().method_1507((class_437)(this.previousScreen != null ? this.previousScreen : new HomeScreen()))));
            this.backAdded = true;
        }
    }

    public void method_25419() {
        super.method_25419();
        if (this.completableFuture != null && !this.completableFuture.isDone() && !this.completableFuture.isCancelled()) {
            this.completableFuture.cancel(true);
        }
    }

    public boolean method_25422() {
        return this.canCancel();
    }

    public boolean canCancel() {
        return this.ticksRunning > 100 || this.error != null;
    }

    public void addHomeButton() {
        this.method_37063(new GuiImageButton(this.bookLeft + 105, this.bookTop + 137, 95, 15, new class_2960("blockprints", "textures/gui/button_6.png"), b -> class_310.method_1551().method_1507((class_437)new HomeScreen())));
        this.addHomeButton = true;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.addHomeButton) {
            graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_home.png"), this.bookLeft + 108, this.bookTop + 140, 0.0f, 0.0f, 9, 8, 9, 8);
            GuiUtils.drawOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.home").method_30937(), this.bookLeft + 128, this.bookTop + 141);
        }
    }

    @Override
    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/container_loading_status.png"), 0, 0, 0.0f, 0.0f, 305, 209, 305, 209);
        if (this.error != null) {
            graphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)this.error), 92, 77, 125, 0xFFFFFF);
            return;
        }
        graphics.method_25290(new class_2960("blockprints", "textures/gui/animation_logo_loading.png"), 144, 91, 0.0f, (float)(26 * (this.anim / 2)), 14, 26, 14, 650);
        String dots = "";
        dots = this.anim < 13 ? "" : (this.anim < 26 ? "." : (this.anim < 39 ? ".." : "..."));
        class_5250 component = class_2561.method_43471((String)"blockprints.loading");
        class_5250 compWithDots = class_2561.method_43470((String)(component.getString() + dots));
        int loadingX = 152;
        int centered = loadingX - this.field_22793.method_27525((class_5348)component) / 2;
        graphics.method_51439(this.field_22793, (class_2561)compWithDots, centered, 120, 0xFFFFFF, false);
    }

    protected record Response<T>(ApiResponse<T> response, @Nullable Throwable throwable) {
    }
}

