/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.api.SceneExporter;
import fabric.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import fabric.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import fabric.com.hollingsworth.schematic.client.ClientData;
import fabric.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import fabric.com.hollingsworth.schematic.client.gui.BlockListScreen;
import fabric.com.hollingsworth.schematic.client.gui.GuiImageButton;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.client.gui.LoadingScreen;
import fabric.com.hollingsworth.schematic.client.gui.PreviewImage;
import fabric.com.hollingsworth.schematic.common.util.ClientUtil;
import fabric.com.hollingsworth.schematic.common.util.FileUtils;
import fabric.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.lwjgl.system.MemoryUtil;

public class DownloadScreen
extends BaseSchematicScreen {
    public static final class_2960 PREVIEW_TEXTURE = new class_2960("blockprints", "download_preview");
    class_1043 dynamicTexture;
    PreviewDownloadResult preview;
    class_437 previousScreen;
    List<BlockListEntry> entries = new ArrayList<BlockListEntry>();
    boolean hasMissing = false;

    public DownloadScreen(class_437 previousScreen, PreviewDownloadResult preview) {
        this.previousScreen = previousScreen;
        this.preview = preview;
        for (class_3545<class_2960, Integer> entry : preview.downloadResponse.blockCounts) {
            class_2960 resourceLocation = new class_2960(((class_2960)entry.method_15442()).toString());
            int count = (Integer)entry.method_15441();
            boolean exists = class_7923.field_41175.method_10250(resourceLocation);
            class_2248 thing = (class_2248)class_7923.field_41175.method_10223(resourceLocation);
            if (!exists) {
                this.entries.add(new BlockListEntry(resourceLocation.toString(), count));
                this.hasMissing = true;
                continue;
            }
            class_1799 renderStack = new class_1799((class_1935)thing);
            this.entries.add(new BlockListEntry(renderStack.method_7964().getString(), (Integer)entry.method_15441(), renderStack));
        }
    }

    public static LoadingScreen<PreviewDownloadResult> getTransition(String schematicId, class_437 previousScreen) {
        return new LoadingScreen<PreviewDownloadResult>(() -> BlockprintsApi.getInstance().download().downloadPreview(schematicId), result -> class_310.method_1551().method_1507((class_437)new DownloadScreen(previousScreen, (PreviewDownloadResult)result)), previousScreen);
    }

    public static class_1043 getTexture(PreviewDownloadResult preview) throws IOException {
        byte[] previewImage = preview.image;
        ByteBuffer buffer = MemoryUtil.memAlloc((int)previewImage.length);
        buffer.put(previewImage);
        class_1011 nativeImage = class_1011.method_4324((ByteBuffer)buffer.flip());
        return new class_1043(nativeImage);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        try {
            this.dynamicTexture = DownloadScreen.getTexture(this.preview);
            class_310.method_1551().method_1531().method_4616(PREVIEW_TEXTURE, (class_1044)this.dynamicTexture);
            this.method_37063(new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, PREVIEW_TEXTURE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuiImageButton downloadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 153, 95, 15, new class_2960("blockprints", "textures/gui/button_6.png"), b -> this.startDownload(path -> {
            class_310.method_1551().method_1507(null);
            if (path != null) {
                ClientUtil.sendMessage("blockprints.download_success");
            } else {
                ClientUtil.sendMessage("blockprints.download_failed");
            }
        }));
        String fileName = SceneExporter.sanitize(this.preview.downloadResponse.structureName + "_" + this.preview.downloadResponse.id) + ".nbt";
        Path path = Paths.get("./schematics/", fileName);
        boolean alreadyDownloaded = Files.exists(path, new LinkOption[0]);
        this.method_37063(new GuiImageButton(this.bookLeft + 25, this.bookTop + 153, 143, 15, new class_2960("blockprints", "textures/gui/button_9.png"), b -> class_310.method_1551().method_1507((class_437)new BlockListScreen(this, this.entries))));
        GuiImageButton visualizeButton = new GuiImageButton(this.bookLeft + 25, this.bookTop + 153 + 16, 143, 15, new class_2960("blockprints", "textures/gui/button_9.png"), b -> {
            Consumer<Path> onPath = templatePath -> {
                class_3499 structureTemplate = FileUtils.loadStructureTemplate((class_7871<class_2248>)class_310.method_1551().field_1687.method_45448(class_7924.field_41254), templatePath);
                StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
                List<class_3499.class_5162> palettes = accessor.getPalettes();
                if (palettes.isEmpty()) {
                    class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"blockprints.invalid_file"));
                } else {
                    ClientData.startStructureRenderer(structureTemplate, this.preview.downloadResponse.structureName, this.preview.downloadResponse.id);
                    class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43469((String)"blockprints.start_placing", (Object[])new Object[]{ClientData.ROTATE_LEFT.method_16007(), ClientData.ROTATE_RIGHT.method_16007(), ClientData.CONFIRM.method_16007(), ClientData.CANCEL.method_16007()}));
                }
                class_310.method_1551().method_1507(null);
            };
            if (!alreadyDownloaded) {
                this.startDownload(onPath);
            } else {
                onPath.accept(path);
            }
        });
        if (alreadyDownloaded) {
            downloadButton.withTooltip((class_2561)class_2561.method_43469((String)"blockprints.already_downloaded_tooltip", (Object[])new Object[]{"./schematics/" + fileName}).method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
        } else {
            downloadButton.withTooltip((class_2561)(this.hasMissing ? class_2561.method_43471((String)"blockprints.blocks_missing_tooltip").method_27696(class_2583.field_24360.method_10977(class_124.field_1061)) : null)).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.download_tooltip"));
            visualizeButton.withTooltip((class_2561)class_2561.method_43471((String)"blockprints.visualize_download"));
        }
        this.method_37063(visualizeButton);
        this.method_37063(downloadButton);
        this.method_37063(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new class_2960("blockprints", "textures/gui/button_back.png"), b -> class_310.method_1551().method_1507(this.previousScreen)));
    }

    public void startDownload(Consumer<Path> callback) {
        class_310.method_1551().method_1507(new LoadingScreen<Path>(() -> BlockprintsApi.getInstance().download().downloadSchematic(this.preview.downloadResponse.id, this.preview.downloadResponse.structureName), callback));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_download.png"), this.bookRight - 116, this.bookTop + 155, 0.0f, 0.0f, 9, 11, 9, 11);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_list.png"), this.bookLeft + 28, this.bookTop + 157, 0.0f, 0.0f, 9, 7, 9, 7);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_visualize.png"), this.bookLeft + 28, this.bookTop + 157 + 16, 0.0f, 0.0f, 9, 7, 9, 7);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.download").method_30937(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.view_list").method_30937(), this.bookLeft + 34 + 71, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.visualize").method_30937(), this.bookLeft + 34 + 71, this.bookTop + 157 + 16);
    }

    @Override
    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/diologue_title_body.png"), 185, 25, 0.0f, 0.0f, 95, 127, 95, 127);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, (class_2561)class_2561.method_43470((String)this.preview.downloadResponse.structureName), 96, 29);
        graphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)this.preview.downloadResponse.description), 187, 44, 95, 0);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, (class_2561)class_2561.method_43471((String)"blockprints.description_title"), 232, 29);
    }

    public void method_25432() {
        super.method_25432();
        class_310.method_1551().method_1531().method_4615(PREVIEW_TEXTURE);
    }

    public static class BlockListEntry {
        public String name;
        public int count;
        public class_1799 renderStack;
        public boolean isMissing;

        public BlockListEntry(String name, int count, class_1799 renderStack) {
            this.name = name;
            this.count = count;
            this.renderStack = renderStack;
            this.isMissing = false;
        }

        public BlockListEntry(String name, int count) {
            this(name, count, class_1799.field_8037);
            this.isMissing = true;
        }
    }
}

