/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client;

import fabric.com.hollingsworth.schematic.client.AreaCaptureHandler;
import fabric.com.hollingsworth.schematic.client.RenderStructureHandler;
import fabric.com.hollingsworth.schematic.client.gui.HomeScreen;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class ClientData {
    private static final String CATEGORY = "key.category.blockprints.general";
    public static final class_304 OPEN_MENU = new class_304("key.blockprints.open_menu", 96, "key.category.blockprints.general");
    public static final class_304 CONFIRM = new class_304("key.blockprints.confirm_selection", 257, "key.category.blockprints.general");
    public static final class_304 CANCEL = new class_304("key.blockprints.cancel_selection", 259, "key.category.blockprints.general");
    public static final class_304 ROTATE_LEFT = new class_304("key.blockprints.rotate_left", 263, "key.category.blockprints.general");
    public static final class_304 ROTATE_RIGHT = new class_304("key.blockprints.rotate_right", 262, "key.category.blockprints.general");
    public static final KeyFunction[] KEY_FUNCTIONS = new KeyFunction[]{new KeyFunction(OPEN_MENU, ClientData::openMenu), new KeyFunction(CONFIRM, ClientData::onConfirmHit), new KeyFunction(CANCEL, ClientData::onCancelHit), new KeyFunction(ROTATE_LEFT, () -> ClientData.onRotateHit(false)), new KeyFunction(ROTATE_RIGHT, () -> ClientData.onRotateHit(true))};

    public static void openMenu() {
        class_310.method_1551().method_1507((class_437)new HomeScreen());
    }

    public static void startBoundaryCapture() {
        AreaCaptureHandler.startCapture();
        RenderStructureHandler.cancelRender();
    }

    public static void startStructureRenderer(class_3499 structureTemplate, String name, String blockprintsId) {
        RenderStructureHandler.startRender(structureTemplate, name, blockprintsId);
        AreaCaptureHandler.cancelCapture();
    }

    public static void onConfirmHit() {
        AreaCaptureHandler.onConfirmHit();
        RenderStructureHandler.onConfirmHit();
    }

    public static void onCancelHit() {
        AreaCaptureHandler.onCancelHit();
        RenderStructureHandler.onCancelHit();
    }

    public static void onRotateHit(boolean clockwise) {
        RenderStructureHandler.onRotateHit(clockwise);
    }

    public static void onMirrorHit() {
        RenderStructureHandler.onMirrorHit();
    }

    public static void renderAfterSky(class_4587 poseStack) {
        AreaCaptureHandler.renderBoundary(poseStack);
    }

    public static void renderAfterTransparentBlocks(class_4587 poseStack, Matrix4f projectionMatrix) {
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.buildRender(data, poseStack, (class_1657)class_310.method_1551().field_1724);
            StructureRenderer.drawRender(data, poseStack, projectionMatrix, (class_1657)class_310.method_1551().field_1724);
        }
    }

    public static void rightClickEvent() {
        AreaCaptureHandler.positionClicked();
        RenderStructureHandler.positionClicked();
    }

    public static void renderGUIOverlayEvent(class_332 graphics, class_1041 window) {
        AreaCaptureHandler.renderBoundaryUI(graphics, window);
        RenderStructureHandler.renderInstructions(graphics, window);
    }

    public record KeyFunction(class_304 mapping, Runnable function) {
    }
}

