/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client;

import fabric.com.hollingsworth.schematic.ClientConstants;
import fabric.com.hollingsworth.schematic.client.ClientData;
import fabric.com.hollingsworth.schematic.client.RaycastHelper;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.client.gui.UploadPreviewScreen;
import fabric.com.hollingsworth.schematic.common.util.SchematicExport;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class AreaCaptureHandler {
    public static class_2338 firstTarget;
    public static class_2338 secondTarget;
    public static boolean showBoundary;
    public static class_2338 selectedPos;

    public static void startCapture() {
        showBoundary = true;
        firstTarget = null;
        secondTarget = null;
    }

    public static void cancelCapture() {
        showBoundary = false;
        firstTarget = null;
        secondTarget = null;
    }

    public static void onConfirmHit() {
        if (!showBoundary) {
            return;
        }
        showBoundary = false;
        if (firstTarget != null && secondTarget != null) {
            class_3499 structure = SchematicExport.getStructure((class_1937)class_310.method_1551().field_1687, firstTarget, secondTarget);
            class_310.method_1551().method_1507((class_437)new UploadPreviewScreen(structure, firstTarget, secondTarget));
        }
    }

    public static void onCancelHit() {
        if (!showBoundary) {
            return;
        }
        AreaCaptureHandler.cancelCapture();
    }

    public static void renderBoundary(class_4587 poseStack) {
        if (!showBoundary) {
            return;
        }
        class_2338 firstPos = firstTarget;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), (class_1657)player, 75.0);
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 hit = trace.method_17777();
            boolean replaceable = player.method_37908().method_8320(hit).method_26166(new class_1750(new class_1838((class_1657)player, class_1268.field_5808, trace)));
            if (trace.method_17780().method_10166().method_10178() && !replaceable) {
                hit = hit.method_10093(trace.method_17780());
            }
            selectedPos = hit;
        } else {
            selectedPos = null;
        }
        if (firstPos == null && selectedPos != null) {
            AreaCaptureHandler.renderBbox(new class_238(selectedPos), poseStack);
            return;
        }
        class_2338 secondPos = secondTarget;
        if (secondPos == null) {
            secondPos = selectedPos;
        }
        class_238 currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (selectedPos == null ? null : new class_238(selectedPos)) : (selectedPos == null ? new class_238(firstPos) : new class_238(firstPos, selectedPos).method_1012(1.0, 1.0, 1.0))) : new class_238(firstPos, secondPos).method_1012(1.0, 1.0, 1.0);
        AreaCaptureHandler.renderBbox(currentSelectionBox, poseStack);
    }

    public static void renderBbox(class_238 currentSelectionBox, class_4587 poseStack) {
        if (currentSelectionBox == null) {
            return;
        }
        class_243 camera = class_310.method_1551().field_1773.method_19418().method_19326();
        currentSelectionBox.method_997(camera.method_1021(-1.0));
        currentSelectionBox = currentSelectionBox.method_989(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        poseStack.method_22903();
        class_4588 vertexconsumer = ClientConstants.bufferSource.getBuffer(class_1921.method_23594());
        class_761.method_22982((class_4587)poseStack, (class_4588)vertexconsumer, (class_238)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        ClientConstants.bufferSource.method_22993();
        poseStack.method_22909();
    }

    public static boolean positionClicked() {
        if (!showBoundary) {
            return false;
        }
        class_2338 pos = selectedPos;
        if (pos == null) {
            return false;
        }
        if (firstTarget == null) {
            firstTarget = pos.method_10062();
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"blockprints.select_second"));
            return true;
        }
        if (secondTarget == null && !firstTarget.equals((Object)pos)) {
            secondTarget = pos.method_10062();
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43469((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.method_16007()}));
            return true;
        }
        return false;
    }

    public static void renderBoundaryUI(class_332 graphics, class_1041 window) {
        if (!showBoundary) {
            return;
        }
        float screenY = (float)window.method_4502() / 2.0f;
        float screenX = (float)window.method_4486() / 2.0f;
        float instructionY = window.method_4502() - 42;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(screenX, instructionY, 0.0f);
        if (firstTarget != null && secondTarget != null) {
            GuiUtils.drawCenteredOutlinedText(class_310.method_1551().field_1772, graphics, class_2561.method_43469((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.method_16007()}).method_30937(), 0, 0);
        } else {
            String compKey = firstTarget == null ? "select_first" : "select_second";
            GuiUtils.drawCenteredOutlinedText(class_310.method_1551().field_1772, graphics, class_2561.method_43471((String)("blockprints." + compKey)).method_30937(), 0, 0);
        }
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(screenX, instructionY + 10.0f, 0.0f);
        GuiUtils.drawCenteredOutlinedText(class_310.method_1551().field_1772, graphics, class_2561.method_43469((String)"blockprints.cancel_selection", (Object[])new Object[]{ClientData.CANCEL.method_16007()}).method_30937(), 0, 0);
        graphics.method_51448().method_22909();
    }

    static {
        selectedPos = null;
    }
}

