/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.api.blockprints;

import fabric.com.hollingsworth.schematic.Constants;
import fabric.com.hollingsworth.schematic.api.SceneExporter;
import fabric.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class GoogleCloudStorage {
    public static String getBucketUrl() {
        if (Constants.isDev) {
            return "https://storage.googleapis.com/blockprints-dev/";
        }
        return "https://storage.googleapis.com/blockprints-prod/";
    }

    public static boolean uploadFileToGCS(URL signedUrl, Path filePath, String contentType, int fileSize) throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(signedUrl.toString())).header("Content-Type", contentType).header("x-goog-content-length-range", "0," + fileSize).PUT(HttpRequest.BodyPublishers.ofFile(filePath)).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            System.out.println(response.body());
        }
        return response.statusCode() == 200;
    }

    public static ApiResponse<byte[]> downloadImage(String gcsPath) {
        return GoogleCloudStorage.downloadRawUrl(URI.create(GoogleCloudStorage.getBucketUrl() + gcsPath));
    }

    public static ApiResponse<byte[]> downloadRawUrl(URI url) {
        ApiResponse<byte[]> apiResponse;
        block8: {
            InputStream in = url.toURL().openStream();
            try {
                apiResponse = ApiResponse.success(in.readAllBytes());
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return ApiResponse.connectionError();
                }
            }
            in.close();
        }
        return apiResponse;
    }

    public static Path downloadFromUrl(URI uri, String folder, String fileName, String extension) {
        Path path;
        block8: {
            String sanitizedName = SceneExporter.sanitize(fileName);
            InputStream in = uri.toURL().openStream();
            try {
                Path path2 = Paths.get(folder + "/" + sanitizedName + extension, new String[0]);
                Files.createDirectories(Paths.get(folder, new String[0]), new FileAttribute[0]);
                Files.copy(in, path2, StandardCopyOption.REPLACE_EXISTING);
                path = path2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            in.close();
        }
        return path;
    }
}

