/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.api.blockprints;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.http.HttpResponse;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ApiResponse<T> {
    public final T response;
    public final String error;

    private ApiResponse(T response) {
        this.response = response;
        this.error = null;
    }

    private ApiResponse(String error) {
        this.response = null;
        this.error = error;
    }

    private ApiResponse(T response, String error) {
        this.response = response;
        this.error = error;
    }

    public boolean wasSuccessful() {
        return this.error == null;
    }

    public ApiResponse<Boolean> toBoolean() {
        return new ApiResponse<Boolean>(this.response != null, this.error);
    }

    public static <T> ApiResponse<T> error(class_2561 component) {
        return new ApiResponse<T>(component.getString());
    }

    public static <T> ApiResponse<T> error(String error) {
        return new ApiResponse<T>(error);
    }

    public static <T> ApiResponse<T> error(ApiResponse<?> response) {
        return new ApiResponse<T>(response.error);
    }

    public static ApiResponse<Boolean> success() {
        return new ApiResponse<Boolean>(true);
    }

    public static <T> ApiResponse<T> success(T response) {
        return new ApiResponse<T>(response);
    }

    public static <F> ApiResponse<F> connectionError() {
        return new ApiResponse(class_2561.method_43471((String)"blockprints.error_loading").getString());
    }

    public static <F> ApiResponse<F> unexpectedFailure() {
        return new ApiResponse(class_2561.method_43471((String)"blockprints.unexpected_error").getString());
    }

    public static <F> ApiResponse<F> parseServerError(HttpResponse<String> error) {
        try {
            JsonObject responseObj = JsonParser.parseString((String)error.body()).getAsJsonObject();
            String errorString = responseObj.get("error").getAsString();
            class_5250 component = class_2561.method_43469((String)"blockprints.error_received", (Object[])new Object[]{errorString});
            return ApiResponse.error((class_2561)component);
        }
        catch (Exception e) {
            return ApiResponse.unexpectedFailure();
        }
    }
}

