/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betterpingdisplay", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static Config instance;
    private static final ClientConfig CLIENT;
    private static final int DEFAULT_PING_TEXT_COLOR = 0xA0A0A0;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private int textColor = 0xA0A0A0;
    private String textFormatString = "%dms";
    private boolean renderPingBars = false;
    private boolean autoColorText = true;

    private static Config from(String textColor, String textFormatString, boolean renderPingBars, boolean autoColorText) {
        Config config = new Config();
        if (textColor.startsWith("#")) {
            try {
                config.textColor = Integer.parseInt(textColor.substring(1), 16);
            }
            catch (NumberFormatException ex) {
                BetterPingDisplayMod.logger().error("Config option 'textColor' is invalid - it must be a hex color code");
                config.textColor = 0xA0A0A0;
            }
        }
        if (textFormatString.contains("%d")) {
            config.textFormatString = textFormatString;
        } else {
            config.textFormatString = DEFAULT_PING_TEXT_FORMAT;
            BetterPingDisplayMod.logger().error("Config option 'textFormatString' is invalid - it needs to contain %d");
        }
        config.renderPingBars = renderPingBars;
        config.autoColorText = autoColorText;
        return config;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public String getTextFormatString() {
        return this.textFormatString;
    }

    public boolean shouldRenderPingBars() {
        return this.renderPingBars;
    }

    public boolean shouldAutoColorText() {
        return this.autoColorText;
    }

    public static Config instance() {
        return instance;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            instance = Config.from((String)Config.CLIENT.textColor.get(), (String)Config.CLIENT.textFormatString.get(), (Boolean)Config.CLIENT.renderPingBars.get(), (Boolean)Config.CLIENT.autoColorText.get());
        }
    }

    private Config() {
    }

    static {
        instance = new Config();
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<String> textColor;
        public final ForgeConfigSpec.ConfigValue<String> textFormatString;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderPingBars;
        public final ForgeConfigSpec.ConfigValue<Boolean> autoColorText;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.textColor = builder.comment(new String[]{"The color of the ping display text, written in hex format. Default: #A0A0A0", "Has no effect if 'autoColorText' is set to true"}).define("textColor", (Object)"#A0A0A0");
            this.textFormatString = builder.comment(new String[]{"Customize the display text of the ping display", "Must contain a '%d', which will be replaced with the ping number", "Example: '%dms' will transform into '123ms' if the player's ping is 123", "Default: %dms"}).define("textFormatString", (Object)Config.DEFAULT_PING_TEXT_FORMAT);
            this.renderPingBars = builder.comment("Whether to also draw the default Minecraft ping bars").define("renderPingBars", false);
            this.autoColorText = builder.comment(new String[]{"Whether to color a player's ping based on their latency.", "Example: low latency = green, high latency = red", "If this setting is true, then the 'textColor' setting is ignored"}).define("autoColorText", true);
        }
    }
}

