/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.config;

import daripher.autoleveling.AutoLevelingMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final Map<Attribute, Float> ATTRIBUTE_BONUSES;

    private static List<List<Object>> getDefaultAttributeBonuses() {
        ArrayList<List<Object>> bonuses = new ArrayList<List<Object>>();
        bonuses.add(Arrays.asList("minecraft:generic.movement_speed", 0.001));
        bonuses.add(Arrays.asList("minecraft:generic.flying_speed", 0.001));
        bonuses.add(Arrays.asList("minecraft:generic.attack_damage", 0.1));
        bonuses.add(Arrays.asList("minecraft:generic.armor", 0.1));
        bonuses.add(Arrays.asList("minecraft:generic.max_health", 0.1));
        bonuses.add(Arrays.asList("autoleveling:monster.projectile_damage_bonus", 0.1));
        bonuses.add(Arrays.asList("autoleveling:monster.explosion_damage_bonus", 0.1));
        return bonuses;
    }

    private static <T> boolean isValidAttributeBonus(T object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Double;
        }
        return false;
    }

    public static Map<Attribute, Float> getAttributeBonuses() {
        if (ATTRIBUTE_BONUSES.isEmpty()) {
            ((List)Config.COMMON.attributesBonuses.get()).forEach(attributeBonusConfig -> {
                ResourceLocation attributeId = new ResourceLocation((String)attributeBonusConfig.get(0));
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeId);
                float attributeBonus = ((Double)attributeBonusConfig.get(1)).floatValue();
                if (attribute == null) {
                    AutoLevelingMod.LOGGER.error("Attribute '" + attributeId + "' can not be found!");
                } else {
                    ATTRIBUTE_BONUSES.put(attribute, Float.valueOf(attributeBonus));
                }
            });
        }
        return ATTRIBUTE_BONUSES;
    }

    public static void registerCommonConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        ATTRIBUTE_BONUSES = new HashMap<Attribute, Float>();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> attributesBonuses;
        public final ForgeConfigSpec.ConfigValue<List<String>> blacklistedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> whitelistedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> blacklistedShownLevels;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultStartingLevel;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultMaxLevel;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultRandomLevelBonus;
        public final ForgeConfigSpec.ConfigValue<Double> expBonus;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDistance;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDeepness;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDay;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelPowerPerDistance;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelPowerPerDeepness;
        public final ForgeConfigSpec.ConfigValue<Boolean> alwaysShowLevel;
        public final ForgeConfigSpec.ConfigValue<Boolean> showLevelWhenLookingAt;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Mobs");
            builder.comment("Example: [\"minecraft:zombie\", \"minecraft:skeleton\"]");
            this.blacklistedMobs = builder.define("List of mobs that shouldn't be able to level up", new ArrayList());
            builder.comment("If this list is not empty only these mobs will be able to level up");
            builder.comment("Example: [\"minecraft:zombie\", \"minecraft:skeleton\"]");
            this.whitelistedMobs = builder.define("List of mobs that should be able to level up", new ArrayList());
            this.alwaysShowLevel = builder.define("Always show mobs levels", false);
            this.showLevelWhenLookingAt = builder.define("Only show levels when you look at the mob", true);
            this.expBonus = builder.define("Bonus experience per level", (Object)0.1);
            this.blacklistedShownLevels = builder.define("List of mobs that should have their levels always hidden", new ArrayList());
            builder.pop();
            builder.push("Attributes");
            builder.comment("Contains a list of pairs of attributes and their bonuses per one level");
            this.attributesBonuses = builder.defineList("Attributes bonuses per one level", Config::getDefaultAttributeBonuses, Config::isValidAttributeBonus);
            builder.pop();
            builder.push("Default levelling settings");
            this.defaultStartingLevel = builder.define("Starting level", (Object)1);
            builder.comment("If this is equal to 0, there will be no maximum level");
            this.defaultMaxLevel = builder.define("Maximum level", (Object)0);
            this.defaultLevelsPerDistance = builder.define("Level increase per one block distance from spawn", (Object)0.01);
            this.defaultLevelsPerDeepness = builder.define("Level increase per one block deepness below sea level", (Object)0.0);
            builder.comment("If this is higher than 0, the level of monsters will be randomly increased by value between 0 and this value");
            this.defaultRandomLevelBonus = builder.define("Random level bonus", (Object)0);
            builder.comment("If this is higher than 0, mobs level will increase every day by specified amount");
            this.defaultLevelsPerDay = builder.define("Level bonus per day", (Object)0.0);
            builder.comment("Exponential level increase with distance");
            this.defaultLevelPowerPerDistance = builder.define("level_power_per_distance", (Object)0.0);
            builder.comment("Exponential level increase with deepness");
            this.defaultLevelPowerPerDeepness = builder.define("level_power_per_deepness", (Object)0.0);
            builder.pop();
        }
    }
}

