/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import daripher.autoleveling.saveddata.GlobalLevelingData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autoleveling")
public class AutoLevelingCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder addGlobalLevelCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"autoleveling").then(Commands.m_82127_((String)"level").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(AutoLevelingCommands::executeAddLevelCommand))))).requires(AutoLevelingCommands::hasPermission);
        event.getDispatcher().register(addGlobalLevelCommand);
        LiteralArgumentBuilder getGlobalLevelCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"autoleveling").then(Commands.m_82127_((String)"level").then(Commands.m_82127_((String)"get").executes(AutoLevelingCommands::executeGetLevelCommand)))).requires(AutoLevelingCommands::hasPermission);
        event.getDispatcher().register(getGlobalLevelCommand);
    }

    private static int executeAddLevelCommand(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        GlobalLevelingData globalLevelingData = GlobalLevelingData.get(server);
        Integer levelBonus = (Integer)ctx.getArgument("value", Integer.class);
        int oldLevelBonus = globalLevelingData.getLevelBonus();
        globalLevelingData.setLevel(oldLevelBonus + levelBonus);
        return 1;
    }

    private static int executeGetLevelCommand(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        GlobalLevelingData globalLevelingData = GlobalLevelingData.get(server);
        int levelBonus = globalLevelingData.getLevelBonus();
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("Global level bonus is " + levelBonus)));
        return 1;
    }

    private static boolean hasPermission(CommandSourceStack commandSourceStack) {
        return commandSourceStack.m_6761_(2);
    }
}

