/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.anti_mob_cheese.anti_mob_farm;

import com.robertx22.anti_mob_cheese.anti_mob_farm.AntiMobFarmData;
import com.robertx22.anti_mob_cheese.configs.CheeseConfig;
import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.utils.LoadSave;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntiMobFarmCap
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("anti_mob_farm", "world_data");
    public static Capability<AntiMobFarmCap> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<AntiMobFarmCap>(){});
    final transient LazyOptional<AntiMobFarmCap> supp = LazyOptional.of(() -> this);
    static String DATA_LOC = "anti_mob_cheese:data";
    AntiMobFarmData data = new AntiMobFarmData();
    Level world;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public static AntiMobFarmCap get(Level provider) {
        return (AntiMobFarmCap)provider.getCapability(INSTANCE).orElse(null);
    }

    public AntiMobFarmCap(Level world) {
        this.world = world;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.data != null) {
            LoadSave.Save((Object)this.data, (CompoundTag)nbt, (String)DATA_LOC);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.data = (AntiMobFarmData)LoadSave.Load(AntiMobFarmData.class, (Object)new AntiMobFarmData(), (CompoundTag)nbt, (String)DATA_LOC);
        if (this.data == null) {
            this.data = new AntiMobFarmData();
        }
    }

    public void onValidMobDeathByPlayer(LivingEntity en) {
        this.data.onValidMobDeathByPlayer(en);
    }

    public float getDropMultiForMob(LivingEntity en) {
        if (!CheeseConfig.get().entityCounts(en)) {
            return 1.0f;
        }
        return this.data.getDropMultiForMob(en);
    }

    public void onMinutePassed() {
        this.data.tickDownAllKillCounters();
    }

    public void onLootChestOpened(ChunkPos pos) {
        this.data.onNewLootChestOpened(pos);
    }

    public String getCapIdForSyncing() {
        return "world_antimobfarm";
    }
}

